/*
 * Decompiled with CFR 0.152.
 */
package hivemall.fm;

import hivemall.common.EtaEstimator;
import hivemall.fm.FactorizationMachineModel;
import hivemall.utils.lang.Primitives;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;

class FMHyperParameters {
    private static final float DEFAULT_ETA0 = 0.05f;
    boolean classification = false;
    int factors = 5;
    float lambda = 0.01f;
    float lambdaW0 = 0.01f;
    float lambdaW = 0.01f;
    float lambdaV = 0.01f;
    double sigma = 0.1;
    long seed = -1L;
    FactorizationMachineModel.VInitScheme vInit;
    double minTarget = Double.MIN_VALUE;
    double maxTarget = Double.MAX_VALUE;
    EtaEstimator eta;
    int numFeatures = -1;
    int iters = 1;
    boolean conversionCheck = true;
    double convergenceRate = 0.005;
    boolean adaptiveReglarization = false;
    float validationRatio = 0.05f;
    int validationThreshold = 1000;
    boolean parseFeatureAsInt = false;

    FMHyperParameters() {
    }

    public String toString() {
        return "FMHyperParameters [classification=" + this.classification + ", factors=" + this.factors + ", lambda=" + this.lambda + ", lambdaW0=" + this.lambdaW0 + ", lambdaW=" + this.lambdaW + ", lambdaV=" + this.lambdaV + ", sigma=" + this.sigma + ", seed=" + this.seed + ", vInit=" + (Object)((Object)this.vInit) + ", minTarget=" + this.minTarget + ", maxTarget=" + this.maxTarget + ", eta=" + this.eta + ", numFeatures=" + this.numFeatures + ", iters=" + this.iters + ", conversionCheck=" + this.conversionCheck + ", convergenceRate=" + this.convergenceRate + ", adaptiveReglarization=" + this.adaptiveReglarization + ", validationRatio=" + this.validationRatio + ", validationThreshold=" + this.validationThreshold + ", parseFeatureAsInt=" + this.parseFeatureAsInt + "]";
    }

    void processOptions(@Nonnull CommandLine cl) throws UDFArgumentException {
        this.classification = cl.hasOption("classification");
        this.factors = Primitives.parseInt(cl.getOptionValue("factors"), this.factors);
        this.lambda = Primitives.parseFloat(cl.getOptionValue("lambda"), this.lambda);
        this.lambdaW0 = Primitives.parseFloat(cl.getOptionValue("lambda_w0"), this.lambda);
        this.lambdaW = Primitives.parseFloat(cl.getOptionValue("lambda_w"), this.lambda);
        this.lambdaV = Primitives.parseFloat(cl.getOptionValue("lambda_v"), this.lambda);
        this.sigma = Primitives.parseDouble(cl.getOptionValue("sigma"), this.sigma);
        this.seed = Primitives.parseLong(cl.getOptionValue("seed"), this.seed);
        if (this.seed == -1L) {
            this.seed = System.nanoTime();
        }
        this.vInit = FMHyperParameters.instantiateVInit(cl, this.factors, this.seed, this.classification);
        this.minTarget = Primitives.parseDouble(cl.getOptionValue("min_target"), this.minTarget);
        this.maxTarget = Primitives.parseDouble(cl.getOptionValue("max_target"), this.maxTarget);
        this.eta = EtaEstimator.get(cl, 0.05f);
        this.numFeatures = Primitives.parseInt(cl.getOptionValue("num_features"), this.numFeatures);
        this.iters = Primitives.parseInt(cl.getOptionValue("iterations"), this.iters);
        this.conversionCheck = !cl.hasOption("disable_cvtest");
        this.convergenceRate = Primitives.parseDouble(cl.getOptionValue("cv_rate"), this.convergenceRate);
        this.adaptiveReglarization = cl.hasOption("adaptive_regularizaion");
        this.validationRatio = Primitives.parseFloat(cl.getOptionValue("validation_ratio"), this.validationRatio);
        if (this.validationRatio < 0.0f || this.validationRatio >= 1.0f) {
            throw new UDFArgumentException("validation_ratio should be in range [0, 1): " + this.validationRatio);
        }
        this.validationThreshold = Primitives.parseInt(cl.getOptionValue("validation_threshold"), this.validationThreshold);
        this.parseFeatureAsInt = cl.hasOption("int_feature");
    }

    @Nonnull
    private static FactorizationMachineModel.VInitScheme instantiateVInit(@Nonnull CommandLine cl, int factor, long seed, boolean classification) {
        String vInitOpt = cl.getOptionValue("init_v");
        float maxInitValue = Primitives.parseFloat(cl.getOptionValue("max_init_value"), 0.5f);
        double initStdDev = Primitives.parseDouble(cl.getOptionValue("min_init_stddev"), 0.1);
        FactorizationMachineModel.VInitScheme defaultInit = classification ? FactorizationMachineModel.VInitScheme.gaussian : FactorizationMachineModel.VInitScheme.random;
        FactorizationMachineModel.VInitScheme vInit = FactorizationMachineModel.VInitScheme.resolve(vInitOpt, defaultInit);
        vInit.setMaxInitValue(maxInitValue);
        initStdDev = Math.max(initStdDev, 1.0 / (double)factor);
        vInit.setInitStdDev(initStdDev);
        vInit.initRandom(factor, seed);
        return vInit;
    }

    public static final class FFMHyperParameters
    extends FMHyperParameters {
        boolean globalBias = false;
        boolean linearCoeff = true;
        int numFields = 1024;
        boolean useAdaGrad = true;
        float eta0_V = 1.0f;
        float eps = 1.0f;
        boolean useFTRL = true;
        float alphaFTRL = 0.1f;
        float betaFTRL = 1.0f;
        float lambda1 = 0.1f;
        float lamdda2 = 0.01f;

        FFMHyperParameters() {
        }

        @Override
        void processOptions(@Nonnull CommandLine cl) throws UDFArgumentException {
            super.processOptions(cl);
            if (cl.hasOption("int_feature")) {
                throw new UDFArgumentException("int_feature option is not supported yet for FFM");
            }
            this.globalBias = cl.hasOption("global_bias");
            boolean bl = this.linearCoeff = !cl.hasOption("no_coeff");
            if (this.numFeatures == -1) {
                int hashbits = Primitives.parseInt(cl.getOptionValue("feature_hashing"), 21);
                if (hashbits < 18 || hashbits > 31) {
                    throw new UDFArgumentException("-feature_hashing MUST be in range [18,31]: " + hashbits);
                }
                this.numFeatures = 1 << hashbits;
            }
            this.numFields = Primitives.parseInt(cl.getOptionValue("num_fields"), this.numFields);
            if (this.numFields <= 1) {
                throw new UDFArgumentException("-num_fields MUST be greater than 1: " + this.numFields);
            }
            this.useAdaGrad = !cl.hasOption("disable_adagrad");
            this.eta0_V = Primitives.parseFloat(cl.getOptionValue("eta0_V"), this.eta0_V);
            this.eps = Primitives.parseFloat(cl.getOptionValue("eps"), this.eps);
            this.useFTRL = !cl.hasOption("disable_ftrl");
            this.alphaFTRL = Primitives.parseFloat(cl.getOptionValue("alphaFTRL"), this.alphaFTRL);
            if (this.alphaFTRL == 0.0f) {
                throw new UDFArgumentException("-alphaFTRL SHOULD NOT be 0");
            }
            this.betaFTRL = Primitives.parseFloat(cl.getOptionValue("betaFTRL"), this.betaFTRL);
            this.lambda1 = Primitives.parseFloat(cl.getOptionValue("lambda1"), this.lambda1);
            this.lamdda2 = Primitives.parseFloat(cl.getOptionValue("lamdda2"), this.lamdda2);
        }

        @Override
        public String toString() {
            return "FFMHyperParameters [globalBias=" + this.globalBias + ", linearCoeff=" + this.linearCoeff + ", numFields=" + this.numFields + ", useAdaGrad=" + this.useAdaGrad + ", eta0_V=" + this.eta0_V + ", eps=" + this.eps + ", useFTRL=" + this.useFTRL + ", alphaFTRL=" + this.alphaFTRL + ", betaFTRL=" + this.betaFTRL + ", lambda1=" + this.lambda1 + ", lamdda2=" + this.lamdda2 + "], " + super.toString();
        }
    }
}

