/*
 * Decompiled with CFR 0.152.
 */
package hivemall.fm;

import hivemall.utils.buffer.HeapBuffer;
import hivemall.utils.lang.NumberUtils;
import javax.annotation.Nonnull;

class Entry {
    @Nonnull
    protected final HeapBuffer _buf;
    protected final int _size;
    protected final int _factors;
    protected long _offset;

    Entry(@Nonnull HeapBuffer buf, int factors) {
        this._buf = buf;
        this._size = Entry.sizeOf(factors);
        this._factors = factors;
    }

    Entry(@Nonnull HeapBuffer buf, int factors, long offset) {
        this(buf, factors, Entry.sizeOf(factors), offset);
    }

    private Entry(@Nonnull HeapBuffer buf, int factors, int size, long offset) {
        this._buf = buf;
        this._size = size;
        this._factors = factors;
        this.setOffset(offset);
    }

    int getSize() {
        return this._size;
    }

    long getOffset() {
        return this._offset;
    }

    void setOffset(long offset) {
        this._offset = offset;
    }

    float getW() {
        return this._buf.getFloat(this._offset);
    }

    void setW(float value) {
        this._buf.putFloat(this._offset, value);
    }

    void getV(@Nonnull float[] Vf) {
        long offset = this._offset + 4L;
        int len = Vf.length;
        for (int i = 0; i < len; ++i) {
            Vf[i] = this._buf.getFloat(offset + (long)(4 * i));
        }
    }

    void setV(@Nonnull float[] Vf) {
        long offset = this._offset + 4L;
        int len = Vf.length;
        for (int i = 0; i < len; ++i) {
            this._buf.putFloat(offset + (long)(4 * i), Vf[i]);
        }
    }

    float getV(int f) {
        return this._buf.getFloat(this._offset + 4L + (long)(4 * f));
    }

    void setV(int f, float value) {
        long index = this._offset + 4L + (long)(4 * f);
        this._buf.putFloat(index, value);
    }

    double getSumOfSquaredGradientsV() {
        throw new UnsupportedOperationException();
    }

    void addGradientV(float grad) {
        throw new UnsupportedOperationException();
    }

    float updateZ(float gradW, float alpha) {
        throw new UnsupportedOperationException();
    }

    double updateN(float gradW) {
        throw new UnsupportedOperationException();
    }

    static int sizeOf(int factors) {
        return 4 + 4 * factors;
    }

    static final class FTRLEntry
    extends AdaGradEntry {
        final long _z_offset;

        FTRLEntry(@Nonnull HeapBuffer buf, int factors, long offset) {
            super(buf, factors, FTRLEntry.sizeOf(factors), offset);
            this._z_offset = this._gg_offset + 8L;
        }

        @Override
        float updateZ(float gradW, float alpha) {
            double gg;
            double n;
            float sigma;
            float W = this.getW();
            float z = this.getZ();
            float newZ = z + gradW - (sigma = (float)((Math.sqrt((n = this.getN()) + (gg = (double)(gradW * gradW))) - Math.sqrt(n)) / (double)alpha)) * W;
            if (!NumberUtils.isFinite(newZ)) {
                throw new IllegalStateException("Got newZ " + newZ + " where z=" + z + ", gradW=" + gradW + ", sigma=" + sigma + ", W=" + W + ", n=" + n + ", gg=" + gg + ", alpha=" + alpha);
            }
            this.setZ(newZ);
            return newZ;
        }

        private float getZ() {
            return this._buf.getFloat(this._z_offset);
        }

        private void setZ(float value) {
            this._buf.putFloat(this._z_offset, value);
        }

        @Override
        double updateN(float gradW) {
            double n = this.getN();
            double newN = n + (double)(gradW * gradW);
            if (!NumberUtils.isFinite(newN)) {
                throw new IllegalStateException("Got newN " + newN + " where n=" + n + ", gradW=" + gradW);
            }
            this.setN(newN);
            return newN;
        }

        private double getN() {
            long index = this._z_offset + 4L;
            return this._buf.getDouble(index);
        }

        private void setN(double value) {
            long index = this._z_offset + 4L;
            this._buf.putDouble(index, value);
        }

        static int sizeOf(int factors) {
            return AdaGradEntry.sizeOf(factors) + 4 + 8;
        }
    }

    static class AdaGradEntry
    extends Entry {
        final long _gg_offset;

        AdaGradEntry(@Nonnull HeapBuffer buf, int factors, long offset) {
            super(buf, factors, AdaGradEntry.sizeOf(factors), offset);
            this._gg_offset = this._offset + 4L + (long)(4 * this._factors);
        }

        private AdaGradEntry(@Nonnull HeapBuffer buf, int factors, int size, long offset) {
            super(buf, factors, size, offset);
            this._gg_offset = this._offset + 4L + (long)(4 * this._factors);
        }

        @Override
        double getSumOfSquaredGradientsV() {
            return this._buf.getDouble(this._gg_offset);
        }

        @Override
        void addGradientV(float grad) {
            double v = this._buf.getDouble(this._gg_offset);
            this._buf.putDouble(this._gg_offset, v += (double)(grad * grad));
        }

        static int sizeOf(int factors) {
            return Entry.sizeOf(factors) + 8;
        }
    }
}

