/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="logloss", value="_FUNC_(double predicted, double actual) - Return a Logrithmic Loss")
public final class LogarithmicLossUDAF
extends UDAF {

    public static class PartialResult {
        double log_sum = 0.0;
        long count = 0L;

        PartialResult() {
        }

        void iterate(double predicted, double actual) {
            double epsilon = 1.0E-15;
            predicted = Math.max(epsilon, predicted);
            predicted = Math.min(1.0 - epsilon, predicted);
            this.log_sum += actual * Math.log(predicted) + (1.0 - actual) * Math.log(1.0 - predicted);
            ++this.count;
        }

        void merge(PartialResult other) {
            this.log_sum += other.log_sum;
            this.count += other.count;
        }

        double getLogLoss() {
            if (this.count == 0L) {
                return 0.0;
            }
            return -1.0 * this.log_sum / (double)this.count;
        }
    }

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(DoubleWritable predicted, DoubleWritable actual) throws HiveException {
            if (predicted == null || actual == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.iterate(predicted.get(), actual.get());
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) throws HiveException {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.merge(other);
            return true;
        }

        public double terminate() {
            if (this.partial == null) {
                return 0.0;
            }
            return this.partial.getLogLoss();
        }
    }
}

