/*
 * Decompiled with CFR 0.152.
 */
package hivemall.evaluation;

import java.util.List;
import javax.annotation.Nonnull;

public final class BinaryResponsesMeasures {
    private BinaryResponsesMeasures() {
    }

    public static double nDCG(@Nonnull List<?> rankedList, @Nonnull List<?> groundTruth) {
        double dcg = 0.0;
        double idcg = BinaryResponsesMeasures.IDCG(groundTruth.size());
        int n = rankedList.size();
        for (int i = 0; i < n; ++i) {
            Object item_id = rankedList.get(i);
            if (!groundTruth.contains(item_id)) continue;
            int rank = i + 1;
            dcg += Math.log(2.0) / Math.log(rank + 1);
        }
        return dcg / idcg;
    }

    public static double IDCG(int n) {
        double idcg = 0.0;
        for (int i = 0; i < n; ++i) {
            idcg += Math.log(2.0) / Math.log(i + 2);
        }
        return idcg;
    }
}

