/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ensemble;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="maxrow", value="_FUNC_(ANY compare, ...) - Returns a row that has maximum value in the 1st argument")
public final class MaxRowUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)parameters[0]);
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)oi)) {
            throw new UDFArgumentTypeException(0, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFMaxRowEvaluator();
    }

    @UDFType(distinctLike=true)
    public static class GenericUDAFMaxRowEvaluator
    extends GenericUDAFEvaluator {
        StructObjectInspector inputStructOI;
        ObjectInspector[] inputOIs;
        ObjectInspector[] outputOIs;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            if (parameters.length == 1 && parameters[0] instanceof StructObjectInspector) {
                return this.initReduceSide((StructObjectInspector)parameters[0]);
            }
            return this.initMapSide(parameters);
        }

        private ObjectInspector initMapSide(ObjectInspector[] parameters) throws HiveException {
            int length = parameters.length;
            this.inputOIs = parameters;
            this.outputOIs = new ObjectInspector[length];
            ArrayList<String> fieldNames = new ArrayList<String>(length);
            List<ObjectInspector> fieldOIs = Arrays.asList(this.outputOIs);
            for (int i = 0; i < length; ++i) {
                fieldNames.add("col" + i);
                this.outputOIs[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[i]);
            }
            return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
        }

        private ObjectInspector initReduceSide(StructObjectInspector inputStructOI) throws HiveException {
            List fields = inputStructOI.getAllStructFieldRefs();
            int length = fields.size();
            this.inputStructOI = inputStructOI;
            this.inputOIs = new ObjectInspector[length];
            this.outputOIs = new ObjectInspector[length];
            for (int i = 0; i < length; ++i) {
                ObjectInspector oi;
                StructField field = (StructField)fields.get(i);
                this.inputOIs[i] = oi = field.getFieldObjectInspector();
                this.outputOIs[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)oi);
            }
            return ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)inputStructOI);
        }

        public MaxAgg getNewAggregationBuffer() throws HiveException {
            MaxAgg maxagg = new MaxAgg();
            maxagg.reset();
            return maxagg;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg maxagg = (MaxAgg)agg;
            maxagg.reset();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            this.merge(agg, parameters);
        }

        public List<Object> terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            List otherObjects;
            if (partial == null) {
                return;
            }
            MaxAgg maxagg = (MaxAgg)agg;
            if (partial instanceof Object[]) {
                otherObjects = Arrays.asList((Object[])partial);
            } else if (partial instanceof LazyBinaryStruct) {
                otherObjects = ((LazyBinaryStruct)partial).getFieldsAsList();
            } else if (this.inputStructOI != null) {
                otherObjects = this.inputStructOI.getStructFieldsDataAsList(partial);
            } else {
                throw new HiveException("Invalid type: " + partial.getClass().getName());
            }
            boolean isMax = false;
            if (maxagg.objects == null) {
                isMax = true;
            } else {
                int cmp = ObjectInspectorUtils.compare((Object)maxagg.objects[0], (ObjectInspector)this.outputOIs[0], otherObjects.get(0), (ObjectInspector)this.inputOIs[0]);
                if (cmp < 0) {
                    isMax = true;
                }
            }
            if (isMax) {
                int length = otherObjects.size();
                maxagg.objects = new Object[length];
                for (int i = 0; i < length; ++i) {
                    maxagg.objects[i] = ObjectInspectorUtils.copyToStandardObject(otherObjects.get(i), (ObjectInspector)this.inputOIs[i]);
                }
            }
        }

        public List<Object> terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg maxagg = (MaxAgg)agg;
            return Arrays.asList(maxagg.objects);
        }

        static class MaxAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            Object[] objects;

            MaxAgg() {
            }

            void reset() {
                this.objects = null;
            }
        }
    }
}

