/*
 * Decompiled with CFR 0.152.
 */
package hivemall.common;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class ReservoirSampler<T> {
    private final T[] samples;
    private final int numSamples;
    private int position;
    private final Random rand;

    public ReservoirSampler(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be greater than 1: " + sampleSize);
        }
        this.samples = new Object[sampleSize];
        this.numSamples = sampleSize;
        this.position = 0;
        this.rand = new Random();
    }

    public ReservoirSampler(int sampleSize, long seed) {
        this.samples = new Object[sampleSize];
        this.numSamples = sampleSize;
        this.position = 0;
        this.rand = new Random(seed);
    }

    public ReservoirSampler(T[] samples) {
        this.samples = samples;
        this.numSamples = samples.length;
        this.position = 0;
        this.rand = new Random();
    }

    public ReservoirSampler(T[] samples, long seed) {
        this.samples = samples;
        this.numSamples = samples.length;
        this.position = 0;
        this.rand = new Random(seed);
    }

    public T[] getSample() {
        return this.samples;
    }

    public List<T> getSamplesAsList() {
        return Arrays.asList(this.samples);
    }

    public void add(T item) {
        if (item == null) {
            return;
        }
        if (this.position < this.numSamples) {
            this.samples[this.position] = item;
        } else {
            int replaceIndex = this.rand.nextInt(this.position + 1);
            if (replaceIndex < this.numSamples) {
                this.samples[replaceIndex] = item;
            }
        }
        ++this.position;
    }

    public void clear() {
        Arrays.fill(this.samples, null);
        this.position = 0;
    }
}

