/*
 * Decompiled with CFR 0.152.
 */
package hivemall.common;

import hivemall.utils.lang.ArrayUtils;
import java.util.Random;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public final class RandomizedAmplifier<T> {
    private final int numBuffers;
    private final int xtimes;
    private final AgedObject<T>[][] slots;
    private int position;
    private final Random[] randoms;
    private DropoutListener<T> listener = null;

    public RandomizedAmplifier(int numBuffers, int xtimes) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("numBuffers must be greater than 0: " + numBuffers);
        }
        if (xtimes < 1) {
            throw new IllegalArgumentException("xtime must be greater than 0: " + xtimes);
        }
        this.numBuffers = numBuffers;
        this.xtimes = xtimes;
        this.slots = new AgedObject[xtimes][numBuffers];
        this.position = 0;
        this.randoms = new Random[xtimes];
        for (int i = 0; i < xtimes; ++i) {
            this.randoms[i] = new Random();
        }
    }

    public RandomizedAmplifier(int numBuffers, int xtimes, long seed) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("numBuffers must be greater than 0: " + numBuffers);
        }
        if (xtimes < 1) {
            throw new IllegalArgumentException("xtime must be greater than 0: " + xtimes);
        }
        this.numBuffers = numBuffers;
        this.xtimes = xtimes;
        this.slots = new AgedObject[xtimes][numBuffers];
        this.position = 0;
        this.randoms = new Random[xtimes];
        for (int i = 0; i < xtimes; ++i) {
            this.randoms[i] = new Random(seed + (long)i);
        }
    }

    public void setDropoutListener(DropoutListener<T> listener) {
        this.listener = listener;
    }

    public void add(T storedObj) throws HiveException {
        block7: {
            block6: {
                int x;
                if (this.position >= this.numBuffers) break block6;
                for (x = 0; x < this.xtimes; ++x) {
                    this.slots[x][this.position] = new AgedObject<T>(storedObj);
                }
                ++this.position;
                if (this.position != this.numBuffers) break block7;
                for (x = 0; x < this.xtimes; ++x) {
                    ArrayUtils.shuffle(this.slots[x], this.randoms[x]);
                }
                break block7;
            }
            for (int x = 0; x < this.xtimes; ++x) {
                AgedObject<T>[] slot = this.slots[x];
                Random rnd = this.randoms[x];
                int rindex1 = rnd.nextInt(this.numBuffers);
                int rindex2 = rnd.nextInt(this.numBuffers);
                AgedObject<T> replaced1 = slot[rindex1];
                AgedObject<T> replaced2 = slot[rindex2];
                assert (replaced1 != null);
                assert (replaced2 != null);
                if (((AgedObject)replaced1).timestamp >= ((AgedObject)replaced2).timestamp) {
                    this.dropout(((AgedObject)replaced1).object);
                    replaced1.set(storedObj);
                    continue;
                }
                this.dropout(((AgedObject)replaced2).object);
                replaced2.set(storedObj);
            }
        }
    }

    public void sweepAll() throws HiveException {
        if (this.position < this.numBuffers && this.position > 1) {
            for (int x = 0; x < this.xtimes; ++x) {
                ArrayUtils.shuffle(this.slots[x], this.position, this.randoms[x]);
            }
        }
        for (int i = 0; i < this.numBuffers; ++i) {
            for (int x = 0; x < this.xtimes; ++x) {
                AgedObject<T>[] slot = this.slots[x];
                AgedObject<T> sweepedObj = slot[i];
                if (sweepedObj == null) continue;
                this.dropout(((AgedObject)sweepedObj).object);
                slot[i] = null;
            }
        }
    }

    protected void dropout(T droppped) throws HiveException {
        if (droppped == null) {
            throw new IllegalStateException("Illegal condition that dropped object is null");
        }
        if (this.listener != null) {
            this.listener.onDrop(droppped);
        }
    }

    public static interface DropoutListener<T> {
        public void onDrop(T var1) throws HiveException;
    }

    private static final class AgedObject<T> {
        private T object;
        private long timestamp;

        AgedObject(T obj) {
            this.object = obj;
            this.timestamp = System.nanoTime();
        }

        void set(T object) {
            this.object = object;
            this.timestamp = System.nanoTime();
        }
    }
}

