/*
 * Decompiled with CFR 0.152.
 */
package hivemall.common;

import hivemall.utils.lang.NumberUtils;
import hivemall.utils.lang.Primitives;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;

public abstract class EtaEstimator {
    protected final float eta0;

    public EtaEstimator(float eta0) {
        this.eta0 = eta0;
    }

    public float eta0() {
        return this.eta0;
    }

    public abstract float eta(long var1);

    public void update(@Nonnegative float multipler) {
    }

    @Nonnull
    public static EtaEstimator get(@Nullable CommandLine cl) throws UDFArgumentException {
        return EtaEstimator.get(cl, 0.1f);
    }

    @Nonnull
    public static EtaEstimator get(@Nullable CommandLine cl, float defaultEta0) throws UDFArgumentException {
        if (cl == null) {
            return new InvscalingEtaEstimator(defaultEta0, 0.1);
        }
        if (cl.hasOption("boldDriver")) {
            float eta = Primitives.parseFloat(cl.getOptionValue("eta"), 0.3f);
            return new AdjustingEtaEstimator(eta);
        }
        String etaValue = cl.getOptionValue("eta");
        if (etaValue != null) {
            float eta = Float.parseFloat(etaValue);
            return new FixedEtaEstimator(eta);
        }
        float eta0 = Primitives.parseFloat(cl.getOptionValue("eta0"), defaultEta0);
        if (cl.hasOption("t")) {
            long t = Long.parseLong(cl.getOptionValue("t"));
            return new SimpleEtaEstimator(eta0, t);
        }
        double power_t = Primitives.parseDouble(cl.getOptionValue("power_t"), 0.1);
        return new InvscalingEtaEstimator(eta0, power_t);
    }

    public static final class AdjustingEtaEstimator
    extends EtaEstimator {
        private float eta;

        public AdjustingEtaEstimator(float eta) {
            super(eta);
            this.eta = eta;
        }

        @Override
        public float eta(long t) {
            return this.eta;
        }

        @Override
        public void update(@Nonnegative float multipler) {
            float newEta = this.eta * multipler;
            if (!NumberUtils.isFinite(newEta)) {
                return;
            }
            this.eta = Math.min(this.eta0, newEta);
        }
    }

    public static final class InvscalingEtaEstimator
    extends EtaEstimator {
        private final double power_t;

        public InvscalingEtaEstimator(float eta0, double power_t) {
            super(eta0);
            this.power_t = power_t;
        }

        @Override
        public float eta(long t) {
            return (float)((double)this.eta0 / Math.pow(t, this.power_t));
        }
    }

    public static final class SimpleEtaEstimator
    extends EtaEstimator {
        private final float finalEta;
        private final double total_steps;

        public SimpleEtaEstimator(float eta0, long total_steps) {
            super(eta0);
            this.finalEta = (float)((double)eta0 / 2.0);
            this.total_steps = total_steps;
        }

        @Override
        public float eta(long t) {
            if ((double)t > this.total_steps) {
                return this.finalEta;
            }
            return (float)((double)this.eta0 / (1.0 + (double)t / this.total_steps));
        }
    }

    public static final class FixedEtaEstimator
    extends EtaEstimator {
        public FixedEtaEstimator(float eta) {
            super(eta);
        }

        @Override
        public float eta(long t) {
            return this.eta0;
        }
    }
}

