/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier.multiclass;

import hivemall.classifier.multiclass.MulticlassOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.Margin;
import hivemall.model.PredictionModel;
import hivemall.model.WeightValue;
import hivemall.utils.math.StatsUtils;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class MulticlassSoftConfidenceWeightedUDTF
extends MulticlassOnlineClassifierUDTF {
    protected float phi;
    protected float c;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("MulticlassSoftConfidenceWeightedUDTF takes 2 or 3 arguments: List<String|Int|BitInt> features, {Int|String} label [, constant String options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected boolean useCovariance() {
        return true;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("phi", "confidence", true, "Confidence parameter [default 1.0]");
        opts.addOption("eta", "hyper_c", true, "Confidence hyperparameter eta in range (0.5, 1] [default 0.85]");
        opts.addOption("c", "aggressiveness", true, "Aggressiveness parameter C [default 1.0]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        float phi = 1.0f;
        float c = 1.0f;
        if (cl != null) {
            String phi_str = cl.getOptionValue("phi");
            if (phi_str == null) {
                String eta_str = cl.getOptionValue("eta");
                if (eta_str != null) {
                    double eta = Double.parseDouble(eta_str);
                    if (eta <= 0.5 || eta > 1.0) {
                        throw new UDFArgumentException("Confidence hyperparameter eta must be in range (0.5, 1]: " + eta_str);
                    }
                    phi = (float)StatsUtils.probit(eta, 5.0);
                }
            } else {
                phi = Float.parseFloat(phi_str);
            }
            String c_str = cl.getOptionValue("c");
            if (c_str != null && !((c = Float.parseFloat(c_str)) > 0.0f)) {
                throw new UDFArgumentException("Aggressiveness parameter C must be C > 0: " + c);
            }
        }
        this.phi = phi;
        this.c = c;
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, @Nonnull Object actual_label) {
        Margin margin = this.getMarginAndVariance(features, actual_label, true);
        float loss = this.loss(margin);
        if (loss > 0.0f) {
            float alpha = this.getAlpha(margin);
            if (alpha == 0.0f) {
                return;
            }
            float beta = this.getBeta(margin, alpha);
            if (beta == 0.0f) {
                return;
            }
            Object missed_label = margin.getMaxIncorrectLabel();
            this.update(features, actual_label, missed_label, alpha, beta);
        }
    }

    protected float loss(Margin margin) {
        float var = margin.getVariance();
        float m = margin.get();
        assert (var != 0.0f);
        float loss = this.phi * (float)Math.sqrt(var) - m;
        return Math.max(loss, 0.0f);
    }

    protected abstract float getAlpha(Margin var1);

    protected abstract float getBeta(Margin var1, float var2);

    protected void update(@Nonnull FeatureValue[] features, Object actual_label, Object missed_label, float alpha, float beta) {
        assert (actual_label != null);
        if (actual_label.equals(missed_label)) {
            throw new IllegalArgumentException("Actual label equals to missed label: " + actual_label);
        }
        PredictionModel model2add = (PredictionModel)this.label2model.get(actual_label);
        if (model2add == null) {
            model2add = this.createModel();
            this.label2model.put(actual_label, model2add);
        }
        PredictionModel model2sub = null;
        if (missed_label != null && (model2sub = (PredictionModel)this.label2model.get(missed_label)) == null) {
            model2sub = this.createModel();
            this.label2model.put(missed_label, model2sub);
        }
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_correctclass_w = model2add.get(k);
            IWeightValue new_correctclass_w = MulticlassSoftConfidenceWeightedUDTF.getNewWeight(old_correctclass_w, v, alpha, beta, true);
            model2add.set(k, new_correctclass_w);
            if (model2sub == null) continue;
            Object old_wrongclass_w = model2sub.get(k);
            IWeightValue new_wrongclass_w = MulticlassSoftConfidenceWeightedUDTF.getNewWeight(old_wrongclass_w, v, alpha, beta, false);
            model2sub.set(k, new_wrongclass_w);
        }
    }

    private static IWeightValue getNewWeight(IWeightValue old, float v, float alpha, float beta, boolean positive) {
        float old_cov;
        float old_v;
        if (old == null) {
            old_v = 0.0f;
            old_cov = 1.0f;
        } else {
            old_v = old.get();
            old_cov = old.getCovariance();
        }
        float cv = old_cov * v;
        float new_w = positive ? old_v + alpha * cv : old_v - alpha * cv;
        float new_cov = old_cov - beta * cv * cv;
        return new WeightValue.WeightValueWithCovar(new_w, new_cov);
    }

    @Description(name="train_multiclass_scw2", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight, float covar>", extended="Build a prediction model by Soft Confidence-Weighted 2 (SCW-2) multiclass classifier")
    public static final class SCW2
    extends SCW1 {
        @Override
        protected float getAlpha(Margin margin) {
            float term;
            float gamma;
            float squared_phi;
            float v_phi_phi;
            float v_phi_phi_m;
            float var;
            float n;
            float m = margin.get();
            float alpha_numer = -(2.0f * m * (n = (var = margin.getVariance()) + this.c / 2.0f) + (v_phi_phi_m = (v_phi_phi = var * (squared_phi = this.phi * this.phi)) * m)) + (gamma = this.phi * (float)Math.sqrt(term = v_phi_phi_m * m * var + 4.0f * n * var * (n + v_phi_phi)));
            if (alpha_numer <= 0.0f) {
                return 0.0f;
            }
            float alpha_denom = 2.0f * (n * n + n * v_phi_phi);
            if (alpha_denom == 0.0f) {
                return 0.0f;
            }
            float alpha = alpha_numer / alpha_denom;
            return Math.max(0.0f, alpha);
        }
    }

    @Description(name="train_multiclass_scw", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight, float covar>", extended="Build a prediction model by Soft Confidence-Weighted (SCW-1) multiclass classifier")
    public static class SCW1
    extends MulticlassSoftConfidenceWeightedUDTF {
        private float squared_phi;
        private float psi;
        private float zeta;

        @Override
        public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
            float phiphi;
            StructObjectInspector oi = super.initialize(argOIs);
            this.squared_phi = phiphi = this.phi * this.phi;
            this.psi = 1.0f + phiphi / 2.0f;
            this.zeta = 1.0f + phiphi;
            return oi;
        }

        @Override
        protected float getAlpha(Margin margin) {
            float m = margin.get();
            float var = margin.getVariance();
            float alpha_numer = -m * this.psi + (float)Math.sqrt(m * m * this.squared_phi * this.squared_phi / 4.0f + var * this.squared_phi * this.zeta);
            float alpha_denom = var * this.zeta;
            if (alpha_denom == 0.0f) {
                return 0.0f;
            }
            float alpha = alpha_numer / alpha_denom;
            if (alpha <= 0.0f) {
                return 0.0f;
            }
            return Math.max(this.c, alpha);
        }

        @Override
        protected float getBeta(Margin margin, float alpha) {
            float beta_numer;
            if (alpha == 0.0f) {
                return 0.0f;
            }
            float var = margin.getVariance();
            float var_alpha_phi = var * (beta_numer = alpha * this.phi);
            float u = -var_alpha_phi + (float)Math.sqrt(var_alpha_phi * var_alpha_phi + 4.0f * var);
            float beta_den = u / 2.0f + var_alpha_phi;
            if (beta_den == 0.0f) {
                return 0.0f;
            }
            float beta = beta_numer / beta_den;
            return beta;
        }
    }
}

