/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier.multiclass;

import hivemall.LearnerBaseUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.Margin;
import hivemall.model.PredictionModel;
import hivemall.model.PredictionResult;
import hivemall.model.WeightValue;
import hivemall.utils.collections.IMapIterator;
import hivemall.utils.datetime.StopWatch;
import hivemall.utils.hadoop.HadoopUtils;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public abstract class MulticlassOnlineClassifierUDTF
extends LearnerBaseUDTF {
    private static final Log logger = LogFactory.getLog(MulticlassOnlineClassifierUDTF.class);
    private ListObjectInspector featureListOI;
    private boolean parseFeature;
    private PrimitiveObjectInspector labelInputOI;
    protected Map<Object, PredictionModel> label2model;
    protected int count;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length < 2) {
            throw new UDFArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " takes 2 arguments: List<Int|BigInt|Text> features, {Int|BitInt|Text} label [, constant text options]");
        }
        PrimitiveObjectInspector featureInputOI = this.processFeaturesOI(argOIs[0]);
        this.labelInputOI = HiveUtils.asPrimitiveObjectInspector(argOIs[1]);
        String labelTypeName = this.labelInputOI.getTypeName();
        if (!("string".equals(labelTypeName) || "int".equals(labelTypeName) || "bigint".equals(labelTypeName))) {
            throw new UDFArgumentTypeException(0, "label must be a type [Int|BigInt|Text]: " + labelTypeName);
        }
        this.processOptions(argOIs);
        JavaIntObjectInspector featureOutputOI = this.dense_model ? PrimitiveObjectInspectorFactory.javaIntObjectInspector : featureInputOI;
        this.label2model = new HashMap<Object, PredictionModel>(64);
        if (this.preloadedModelFile != null) {
            this.loadPredictionModel(this.label2model, this.preloadedModelFile, this.labelInputOI, (PrimitiveObjectInspector)featureOutputOI);
        }
        this.count = 0;
        return this.getReturnOI((ObjectInspector)this.labelInputOI, (ObjectInspector)featureOutputOI);
    }

    @Override
    protected int getInitialModelSize() {
        return 8192;
    }

    protected PrimitiveObjectInspector processFeaturesOI(ObjectInspector arg) throws UDFArgumentException {
        this.featureListOI = (ListObjectInspector)arg;
        ObjectInspector featureRawOI = this.featureListOI.getListElementObjectInspector();
        String keyTypeName = featureRawOI.getTypeName();
        if (!("string".equals(keyTypeName) || "int".equals(keyTypeName) || "bigint".equals(keyTypeName))) {
            throw new UDFArgumentTypeException(0, "1st argument must be Map of key type [Int|BitInt|Text]: " + keyTypeName);
        }
        this.parseFeature = "string".equals(keyTypeName);
        return HiveUtils.asPrimitiveObjectInspector(featureRawOI);
    }

    protected StructObjectInspector getReturnOI(ObjectInspector labelRawOI, ObjectInspector featureRawOI) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Object> fieldOIs = new ArrayList<Object>();
        fieldNames.add("label");
        ObjectInspector labelOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)labelRawOI);
        fieldOIs.add(labelOI);
        fieldNames.add("feature");
        ObjectInspector featureOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)featureRawOI);
        fieldOIs.add(featureOI);
        fieldNames.add("weight");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        if (this.useCovariance()) {
            fieldNames.add("covar");
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        List features = this.featureListOI.getList(args[0]);
        FeatureValue[] featureVector = this.parseFeatures(features);
        if (featureVector == null) {
            return;
        }
        Object label = ObjectInspectorUtils.copyToStandardObject((Object)args[1], (ObjectInspector)this.labelInputOI);
        if (label == null) {
            throw new UDFArgumentException("label value must not be NULL");
        }
        ++this.count;
        this.train(featureVector, label);
    }

    @Nullable
    protected final FeatureValue[] parseFeatures(@Nonnull List<?> features) {
        int size = features.size();
        if (size == 0) {
            return null;
        }
        ObjectInspector featureInspector = this.featureListOI.getListElementObjectInspector();
        FeatureValue[] featureVector = new FeatureValue[size];
        for (int i = 0; i < size; ++i) {
            FeatureValue fv;
            Object f = features.get(i);
            if (f == null) continue;
            if (this.parseFeature) {
                fv = FeatureValue.parse(f);
            } else {
                Object k = ObjectInspectorUtils.copyToStandardObject(f, (ObjectInspector)featureInspector);
                fv = new FeatureValue(k, 1.0f);
            }
            featureVector[i] = fv;
        }
        return featureVector;
    }

    protected abstract void train(@Nonnull FeatureValue[] var1, @Nonnull Object var2);

    protected final PredictionResult classify(@Nonnull FeatureValue[] features) {
        float maxScore = Float.MIN_VALUE;
        Object maxScoredLabel = null;
        for (Map.Entry<Object, PredictionModel> label2map : this.label2model.entrySet()) {
            Object label = label2map.getKey();
            PredictionModel model = label2map.getValue();
            float score = this.calcScore(model, features);
            if (maxScoredLabel != null && !(score > maxScore)) continue;
            maxScore = score;
            maxScoredLabel = label;
        }
        return new PredictionResult(maxScoredLabel, maxScore);
    }

    protected Margin getMargin(@Nonnull FeatureValue[] features, Object actual_label) {
        float correctScore = 0.0f;
        Object maxAnotherLabel = null;
        float maxAnotherScore = 0.0f;
        for (Map.Entry<Object, PredictionModel> label2map : this.label2model.entrySet()) {
            Object label = label2map.getKey();
            PredictionModel model = label2map.getValue();
            float score = this.calcScore(model, features);
            if (label.equals(actual_label)) {
                correctScore = score;
                continue;
            }
            if (maxAnotherLabel != null && !(score > maxAnotherScore)) continue;
            maxAnotherLabel = label;
            maxAnotherScore = score;
        }
        return new Margin(correctScore, maxAnotherLabel, maxAnotherScore);
    }

    protected Margin getMarginAndVariance(@Nonnull FeatureValue[] features, Object actual_label) {
        return this.getMarginAndVariance(features, actual_label, false);
    }

    protected Margin getMarginAndVariance(@Nonnull FeatureValue[] features, Object actual_label, boolean nonZeroVariance) {
        float correctScore = 0.0f;
        float correctVariance = 0.0f;
        Object maxAnotherLabel = null;
        float maxAnotherScore = 0.0f;
        float maxAnotherVariance = 0.0f;
        if (nonZeroVariance && this.label2model.isEmpty()) {
            float var = 2.0f * this.calcVariance(features);
            return new Margin(correctScore, maxAnotherLabel, maxAnotherScore).variance(var);
        }
        for (Map.Entry<Object, PredictionModel> label2map : this.label2model.entrySet()) {
            Object label = label2map.getKey();
            PredictionModel model = label2map.getValue();
            PredictionResult predicted = this.calcScoreAndVariance(model, features);
            float score = predicted.getScore();
            if (label.equals(actual_label)) {
                correctScore = score;
                correctVariance = predicted.getVariance();
                continue;
            }
            if (maxAnotherLabel != null && !(score > maxAnotherScore)) continue;
            maxAnotherLabel = label;
            maxAnotherScore = score;
            maxAnotherVariance = predicted.getVariance();
        }
        float var = correctVariance + maxAnotherVariance;
        return new Margin(correctScore, maxAnotherLabel, maxAnotherScore).variance(var);
    }

    protected final float squaredNorm(@Nonnull FeatureValue[] features) {
        float squared_norm = 0.0f;
        for (FeatureValue f : features) {
            if (f == null) continue;
            float v = f.getValueAsFloat();
            squared_norm += v * v;
        }
        return squared_norm;
    }

    protected final float calcScore(@Nonnull PredictionModel model, @Nonnull FeatureValue[] features) {
        float score = 0.0f;
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            float old_w = model.getWeight(k);
            if (old_w == 0.0f) continue;
            score += old_w * v;
        }
        return score;
    }

    protected final float calcVariance(@Nonnull FeatureValue[] features) {
        float variance = 0.0f;
        for (FeatureValue f : features) {
            if (f == null) continue;
            float v = f.getValueAsFloat();
            variance += v * v;
        }
        return variance;
    }

    protected final PredictionResult calcScoreAndVariance(@Nonnull PredictionModel model, @Nonnull FeatureValue[] features) {
        float score = 0.0f;
        float variance = 0.0f;
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_w = model.get(k);
            if (old_w == null) {
                variance += 1.0f * v * v;
                continue;
            }
            score += old_w.get() * v;
            variance += old_w.getCovariance() * v * v;
        }
        return new PredictionResult(score).variance(variance);
    }

    protected void update(@Nonnull FeatureValue[] features, float coeff, Object actual_label, Object missed_label) {
        assert (actual_label != null);
        if (actual_label.equals(missed_label)) {
            throw new IllegalArgumentException("Actual label equals to missed label: " + actual_label);
        }
        PredictionModel model2add = this.label2model.get(actual_label);
        if (model2add == null) {
            model2add = this.createModel();
            this.label2model.put(actual_label, model2add);
        }
        PredictionModel model2sub = null;
        if (missed_label != null && (model2sub = this.label2model.get(missed_label)) == null) {
            model2sub = this.createModel();
            this.label2model.put(missed_label, model2sub);
        }
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            float old_trueclass_w = model2add.getWeight(k);
            float add_w = old_trueclass_w + coeff * v;
            model2add.set(k, new WeightValue(add_w));
            if (model2sub == null) continue;
            float old_falseclass_w = model2sub.getWeight(k);
            float sub_w = old_falseclass_w - coeff * v;
            model2sub.set(k, new WeightValue(sub_w));
        }
    }

    @Override
    public final void close() throws HiveException {
        super.close();
        if (this.label2model != null) {
            long numForwarded = 0L;
            long numMixed = 0L;
            if (this.useCovariance()) {
                WeightValue.WeightValueWithCovar probe = new WeightValue.WeightValueWithCovar();
                Object[] forwardMapObj = new Object[4];
                FloatWritable fv = new FloatWritable();
                FloatWritable cov = new FloatWritable();
                for (Map.Entry<Object, PredictionModel> entry : this.label2model.entrySet()) {
                    Object label;
                    forwardMapObj[0] = label = entry.getKey();
                    PredictionModel model = entry.getValue();
                    numMixed += model.getNumMixed();
                    IMapIterator itor = model.entries();
                    while (itor.next() != -1) {
                        itor.getValue(probe);
                        if (!probe.isTouched()) continue;
                        Object k = itor.getKey();
                        fv.set(probe.get());
                        cov.set(probe.getCovariance());
                        forwardMapObj[1] = k;
                        forwardMapObj[2] = fv;
                        forwardMapObj[3] = cov;
                        this.forward(forwardMapObj);
                        ++numForwarded;
                    }
                }
            } else {
                WeightValue probe = new WeightValue();
                Object[] forwardMapObj = new Object[3];
                FloatWritable fv = new FloatWritable();
                for (Map.Entry<Object, PredictionModel> entry : this.label2model.entrySet()) {
                    Object label;
                    forwardMapObj[0] = label = entry.getKey();
                    PredictionModel model = entry.getValue();
                    numMixed += model.getNumMixed();
                    IMapIterator itor = model.entries();
                    while (itor.next() != -1) {
                        itor.getValue(probe);
                        if (!probe.isTouched()) continue;
                        Object k = itor.getKey();
                        fv.set(probe.get());
                        forwardMapObj[1] = k;
                        forwardMapObj[2] = fv;
                        this.forward(forwardMapObj);
                        ++numForwarded;
                    }
                }
            }
            this.label2model = null;
            logger.info((Object)("Trained a prediction model using " + this.count + " training examples" + (numMixed > 0L ? "( numMixed: " + numMixed + " )" : "")));
            logger.info((Object)("Forwarded the prediction model of " + numForwarded + " rows"));
        }
    }

    protected void loadPredictionModel(Map<Object, PredictionModel> label2model, String filename, PrimitiveObjectInspector labelOI, PrimitiveObjectInspector featureOI) {
        long lines;
        StopWatch elapsed = new StopWatch();
        try {
            lines = this.useCovariance() ? this.loadPredictionModel(label2model, new File(filename), labelOI, featureOI, PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector) : this.loadPredictionModel(label2model, new File(filename), labelOI, featureOI, PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load a model: " + filename, e);
        }
        catch (SerDeException e) {
            throw new RuntimeException("Failed to load a model: " + filename, e);
        }
        if (!label2model.isEmpty()) {
            long totalFeatures = 0L;
            StringBuilder statsBuf = new StringBuilder(256);
            for (Map.Entry<Object, PredictionModel> e : label2model.entrySet()) {
                Object label = e.getKey();
                int numFeatures = e.getValue().size();
                statsBuf.append('\n').append("Label: ").append(label).append(", Number of Features: ").append(numFeatures);
                totalFeatures += (long)numFeatures;
            }
            logger.info((Object)("Loaded total " + totalFeatures + " features from distributed cache '" + filename + "' (" + lines + " lines) in " + elapsed + statsBuf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadPredictionModel(Map<Object, PredictionModel> label2model, File file, PrimitiveObjectInspector labelOI, PrimitiveObjectInspector featureOI, WritableFloatObjectInspector weightOI) throws IOException, SerDeException {
        long count;
        block9: {
            count = 0L;
            if (!file.exists()) {
                return count;
            }
            if (file.getName().endsWith(".crc")) break block9;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    count += this.loadPredictionModel(label2model, f, labelOI, featureOI, weightOI);
                }
            } else {
                LazySimpleSerDe serde = HiveUtils.getLineSerde(new PrimitiveObjectInspector[]{labelOI, featureOI, weightOI});
                StructObjectInspector lineOI = (StructObjectInspector)serde.getObjectInspector();
                StructField c1ref = lineOI.getStructFieldRef("c1");
                StructField c2ref = lineOI.getStructFieldRef("c2");
                StructField c3ref = lineOI.getStructFieldRef("c3");
                PrimitiveObjectInspector c1refOI = (PrimitiveObjectInspector)c1ref.getFieldObjectInspector();
                PrimitiveObjectInspector c2refOI = (PrimitiveObjectInspector)c2ref.getFieldObjectInspector();
                FloatObjectInspector c3refOI = (FloatObjectInspector)c3ref.getFieldObjectInspector();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = HadoopUtils.getBufferedReader(file);
                    while ((line = reader.readLine()) != null) {
                        ++count;
                        Text lineText = new Text(line);
                        Object lineObj = serde.deserialize((Writable)lineText);
                        List fields = lineOI.getStructFieldsDataAsList(lineObj);
                        Object f0 = fields.get(0);
                        Object f1 = fields.get(1);
                        Object f2 = fields.get(2);
                        if (f0 == null || f1 == null || f2 == null) continue;
                        Object label = c1refOI.getPrimitiveWritableObject(c1refOI.copyObject(f0));
                        PredictionModel model = label2model.get(label);
                        if (model == null) {
                            model = this.createModel();
                            label2model.put(label, model);
                        }
                        Object k = c2refOI.getPrimitiveWritableObject(c2refOI.copyObject(f1));
                        float v = c3refOI.get(f2);
                        model.set(k, new WeightValue(v, false));
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)reader);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadPredictionModel(Map<Object, PredictionModel> label2model, File file, PrimitiveObjectInspector labelOI, PrimitiveObjectInspector featureOI, WritableFloatObjectInspector weightOI, WritableFloatObjectInspector covarOI) throws IOException, SerDeException {
        long count;
        block9: {
            count = 0L;
            if (!file.exists()) {
                return count;
            }
            if (file.getName().endsWith(".crc")) break block9;
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    count += this.loadPredictionModel(label2model, f, labelOI, featureOI, weightOI, covarOI);
                }
            } else {
                LazySimpleSerDe serde = HiveUtils.getLineSerde(new PrimitiveObjectInspector[]{labelOI, featureOI, weightOI, covarOI});
                StructObjectInspector lineOI = (StructObjectInspector)serde.getObjectInspector();
                StructField c1ref = lineOI.getStructFieldRef("c1");
                StructField c2ref = lineOI.getStructFieldRef("c2");
                StructField c3ref = lineOI.getStructFieldRef("c3");
                StructField c4ref = lineOI.getStructFieldRef("c4");
                PrimitiveObjectInspector c1refOI = (PrimitiveObjectInspector)c1ref.getFieldObjectInspector();
                PrimitiveObjectInspector c2refOI = (PrimitiveObjectInspector)c2ref.getFieldObjectInspector();
                FloatObjectInspector c3refOI = (FloatObjectInspector)c3ref.getFieldObjectInspector();
                FloatObjectInspector c4refOI = (FloatObjectInspector)c4ref.getFieldObjectInspector();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = HadoopUtils.getBufferedReader(file);
                    while ((line = reader.readLine()) != null) {
                        ++count;
                        Text lineText = new Text(line);
                        Object lineObj = serde.deserialize((Writable)lineText);
                        List fields = lineOI.getStructFieldsDataAsList(lineObj);
                        Object f0 = fields.get(0);
                        Object f1 = fields.get(1);
                        Object f2 = fields.get(2);
                        Object f3 = fields.get(3);
                        if (f0 == null || f1 == null || f2 == null) continue;
                        Object label = c1refOI.getPrimitiveWritableObject(c1refOI.copyObject(f0));
                        PredictionModel model = label2model.get(label);
                        if (model == null) {
                            model = this.createModel();
                            label2model.put(label, model);
                        }
                        Object k = c2refOI.getPrimitiveWritableObject(c2refOI.copyObject(f1));
                        float v = c3refOI.get(f2);
                        float cov = f3 == null ? 1.0f : c4refOI.get(f3);
                        model.set(k, new WeightValue.WeightValueWithCovar(v, cov, false));
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)reader);
                }
            }
        }
        return count;
    }
}

