/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier.multiclass;

import hivemall.classifier.multiclass.MulticlassOnlineClassifierUDTF;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.Margin;
import hivemall.model.PredictionModel;
import hivemall.model.WeightValue;
import hivemall.utils.math.StatsUtils;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_multiclass_cw", value="_FUNC_(list<string|int|bigint> features, {int|string} label [, const string options]) - Returns a relation consists of <{int|string} label, {string|int|bigint} feature, float weight, float covar>", extended="Build a prediction model by Confidence-Weighted (CW) multiclass classifier")
public class MulticlassConfidenceWeightedUDTF
extends MulticlassOnlineClassifierUDTF {
    protected float phi;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<String|Int|BitInt> features, {Int|String} label [, constant String options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected boolean useCovariance() {
        return true;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("phi", "confidence", true, "Confidence parameter [default 1.0]");
        opts.addOption("eta", "hyper_c", true, "Confidence hyperparameter eta in range (0.5, 1] [default 0.85]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        float phi = 1.0f;
        if (cl != null) {
            String phi_str = cl.getOptionValue("phi");
            if (phi_str == null) {
                String eta_str = cl.getOptionValue("eta");
                if (eta_str != null) {
                    double eta = Double.parseDouble(eta_str);
                    if (eta <= 0.5 || eta > 1.0) {
                        throw new UDFArgumentException("Confidence hyperparameter eta must be in range (0.5, 1]: " + eta_str);
                    }
                    phi = (float)StatsUtils.probit(eta, 5.0);
                }
            } else {
                phi = Float.parseFloat(phi_str);
            }
        }
        this.phi = phi;
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, @Nonnull Object actual_label) {
        Margin margin = this.getMarginAndVariance(features, actual_label, true);
        float gamma = this.getGamma(margin);
        if (gamma > 0.0f) {
            Object missed_label = margin.getMaxIncorrectLabel();
            this.update(features, gamma, actual_label, missed_label);
        }
    }

    protected final float getGamma(Margin margin) {
        float m = margin.get();
        float var = margin.getVariance();
        assert (var != 0.0f);
        float b = 1.0f + 2.0f * this.phi * m;
        float gamma_numer = -b + (float)Math.sqrt(b * b - 8.0f * this.phi * (m - this.phi * var));
        float gamma_denom = 4.0f * this.phi * var;
        if (gamma_denom == 0.0f) {
            return 0.0f;
        }
        return gamma_numer / gamma_denom;
    }

    @Override
    protected void update(@Nonnull FeatureValue[] features, float alpha, Object actual_label, Object missed_label) {
        assert (actual_label != null);
        if (actual_label.equals(missed_label)) {
            throw new IllegalArgumentException("Actual label equals to missed label: " + actual_label);
        }
        PredictionModel model2add = (PredictionModel)this.label2model.get(actual_label);
        if (model2add == null) {
            model2add = this.createModel();
            this.label2model.put(actual_label, model2add);
        }
        PredictionModel model2sub = null;
        if (missed_label != null && (model2sub = (PredictionModel)this.label2model.get(missed_label)) == null) {
            model2sub = this.createModel();
            this.label2model.put(missed_label, model2sub);
        }
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_correctclass_w = model2add.get(k);
            IWeightValue new_correctclass_w = MulticlassConfidenceWeightedUDTF.getNewWeight(old_correctclass_w, v, alpha, this.phi, true);
            model2add.set(k, new_correctclass_w);
            if (model2sub == null) continue;
            Object old_wrongclass_w = model2sub.get(k);
            IWeightValue new_wrongclass_w = MulticlassConfidenceWeightedUDTF.getNewWeight(old_wrongclass_w, v, alpha, this.phi, false);
            model2sub.set(k, new_wrongclass_w);
        }
    }

    private static IWeightValue getNewWeight(IWeightValue old, float x, float alpha, float phi, boolean positive) {
        float old_cov;
        float old_w;
        if (old == null) {
            old_w = 0.0f;
            old_cov = 1.0f;
        } else {
            old_w = old.get();
            old_cov = old.getCovariance();
        }
        float delta_w = alpha * old_cov * x;
        float new_w = positive ? old_w + delta_w : old_w - delta_w;
        float new_cov = 1.0f / (1.0f / old_cov + 2.0f * alpha * phi * x * x);
        return new WeightValue.WeightValueWithCovar(new_w, new_cov);
    }
}

