/*
 * Decompiled with CFR 0.152.
 */
package hivemall.classifier;

import hivemall.classifier.BinaryOnlineClassifierUDTF;
import hivemall.common.LossFunctions;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.PredictionResult;
import hivemall.model.WeightValue;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_arow", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight, float covar>", extended="Build a prediction model by Adaptive Regularization of Weight Vectors (AROW) binary classifier")
public class AROWClassifierUDTF
extends BinaryOnlineClassifierUDTF {
    protected float r;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("_FUNC_ takes 2 or 3 arguments: List<String|Int|BitInt> features, Int label [, constant String options]");
        }
        return super.initialize(argOIs);
    }

    @Override
    protected boolean useCovariance() {
        return true;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("r", "regularization", true, "Regularization parameter for some r > 0 [default 0.1]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        String r_str;
        CommandLine cl = super.processOptions(argOIs);
        float r = 0.1f;
        if (cl != null && (r_str = cl.getOptionValue("r")) != null && !((r = Float.parseFloat(r_str)) > 0.0f)) {
            throw new UDFArgumentException("Regularization parameter must be greater than 0: " + r_str);
        }
        this.r = r;
        return cl;
    }

    @Override
    protected void train(@Nonnull FeatureValue[] features, int label) {
        float y = label > 0 ? 1.0f : -1.0f;
        PredictionResult margin = this.calcScoreAndVariance(features);
        float m = margin.getScore() * y;
        if (m < 1.0f) {
            float var = margin.getVariance();
            float beta = 1.0f / (var + this.r);
            float alpha = (1.0f - m) * beta;
            this.update(features, y, alpha, beta);
        }
    }

    protected float loss(PredictionResult margin, float y) {
        float m = margin.getScore() * y;
        return m < 0.0f ? 1.0f : 0.0f;
    }

    protected void update(@Nonnull FeatureValue[] features, float y, float alpha, float beta) {
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object k = f.getFeature();
            float v = f.getValueAsFloat();
            Object old_w = this.model.get(k);
            IWeightValue new_w = AROWClassifierUDTF.getNewWeight(old_w, v, y, alpha, beta);
            this.model.set(k, new_w);
        }
    }

    private static IWeightValue getNewWeight(IWeightValue old, float x, float y, float alpha, float beta) {
        float old_cov;
        float old_w;
        if (old == null) {
            old_w = 0.0f;
            old_cov = 1.0f;
        } else {
            old_w = old.get();
            old_cov = old.getCovariance();
        }
        float cv = old_cov * x;
        float new_w = old_w + y * alpha * cv;
        float new_cov = old_cov - beta * cv * cv;
        return new WeightValue.WeightValueWithCovar(new_w, new_cov);
    }

    @Description(name="train_arowh", value="_FUNC_(list<string|int|bigint> features, int label [, const string options]) - Returns a relation consists of <string|int|bigint feature, float weight, float covar>", extended="Build a prediction model by AROW binary classifier using hinge loss")
    public static class AROWh
    extends AROWClassifierUDTF {
        protected float c;

        @Override
        protected Options getOptions() {
            Options opts = super.getOptions();
            opts.addOption("c", "aggressiveness", true, "Aggressiveness parameter C [default 1.0]");
            return opts;
        }

        @Override
        protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
            String c_str;
            CommandLine cl = super.processOptions(argOIs);
            float c = 1.0f;
            if (cl != null && (c_str = cl.getOptionValue("c")) != null && !((c = Float.parseFloat(c_str)) > 0.0f)) {
                throw new UDFArgumentException("Aggressiveness parameter C must be C > 0: " + c);
            }
            this.c = c;
            return cl;
        }

        @Override
        protected void train(@Nonnull FeatureValue[] features, int label) {
            float y = label > 0 ? 1.0f : -1.0f;
            PredictionResult margin = this.calcScoreAndVariance(features);
            float p = margin.getScore();
            float loss = this.loss(p, y);
            if (loss > 0.0f) {
                float var = margin.getVariance();
                float beta = 1.0f / (var + this.r);
                float alpha = loss * beta;
                this.update(features, y, alpha, beta);
            }
        }

        protected float loss(float p, float y) {
            return LossFunctions.hingeLoss(p, y, this.c);
        }
    }
}

