/*
 * Decompiled with CFR 0.152.
 */
package hivemall;

import hivemall.utils.lang.CommandLineUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Reporter;

public abstract class UDFWithOptions
extends GenericUDF {
    @Nullable
    protected MapredContext mapredContext;

    public final void configure(MapredContext mapredContext) {
        this.mapredContext = mapredContext;
    }

    @Nullable
    protected final Reporter getReporter() {
        if (this.mapredContext == null) {
            return null;
        }
        return this.mapredContext.getReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reportProgress(@Nonnull Reporter reporter) {
        if (reporter != null) {
            Reporter reporter2 = reporter;
            synchronized (reporter2) {
                reporter.progress();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setCounterValue(@Nullable Counters.Counter counter, long value) {
        if (counter != null) {
            Counters.Counter counter2 = counter;
            synchronized (counter2) {
                counter.setValue(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void incrCounter(@Nullable Counters.Counter counter, long incr) {
        if (counter != null) {
            Counters.Counter counter2 = counter;
            synchronized (counter2) {
                counter.increment(incr);
            }
        }
    }

    protected abstract Options getOptions();

    protected final CommandLine parseOptions(String optionValue) throws UDFArgumentException {
        String[] args = optionValue.split("\\s+");
        Options opts = this.getOptions();
        opts.addOption("help", false, "Show function help");
        CommandLine cl = CommandLineUtils.parseOptions(args, opts);
        if (cl.hasOption("help")) {
            String funcName;
            Description funcDesc = ((Object)((Object)this)).getClass().getAnnotation(Description.class);
            String cmdLineSyntax = funcDesc == null ? ((Object)((Object)this)).getClass().getSimpleName() : ((funcName = funcDesc.name()) == null ? ((Object)((Object)this)).getClass().getSimpleName() : funcDesc.value().replace("_FUNC_", funcDesc.name()));
            StringWriter sw = new StringWriter();
            sw.write(10);
            PrintWriter pw = new PrintWriter(sw);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(pw, 74, cmdLineSyntax, null, opts, 1, 3, null, true);
            pw.flush();
            String helpMsg = sw.toString();
            throw new UDFArgumentException(helpMsg);
        }
        return cl;
    }

    protected abstract CommandLine processOptions(@Nonnull String var1) throws UDFArgumentException;
}

